#include "commonheaders.h"
#include "cls-window.h"
#include "cls-windraw.h"

Selector::Selector(short xLocation, short yLocation, short winWidth, short winHeight, char *text, short *refval, short triggerval) {
    label = (char *)qualloc(strlen(text)+1);
    Init_String(label, text, 0);
    xPos = xLocation;
    yPos = yLocation;
    width = winWidth;
    height = winHeight;
    ref = refval;
    trig = triggerval;
    visible = true;
    disabled = false;
    selectable = true;
    
    image = NULL;
    highlight = create_bitmap(width + 1, height + 1);
    clear_to_color(highlight, makecol(192,192,192));
    layer = create_bitmap(width + 1, height + 1);
    clear_to_color(layer, 0);
}
Selector::Selector(short xLocation, short yLocation, short winWidth, short winHeight, BITMAP *mainImage, short *refval, short triggerval) {
    image = mainImage;
    xPos = xLocation;
    yPos = yLocation;
    width = winWidth;
    height = winHeight;
    ref = refval;
    trig = triggerval;
    visible = true;
    disabled = false;
    selectable = true;
    callfunct = false;
    
    label = NULL;
    highlight = create_bitmap(width, height);
    clear_to_color(highlight, makecol(192,192,192));
    layer = create_bitmap(width + 1, height + 1);
    clear_to_color(layer, 0);
}
bool Selector::SetImage(BITMAP *newImage) {
    if(image == NULL) {
        free(label);
        label = NULL;
    }
    image = newImage;
}
void Selector::FreeImage(void) {
    if(image != NULL) {
        destroy_bitmap(image);
    }
}
bool Selector::SetText(char *newString) {
    if(label == NULL) {
        image = NULL;
        label = (char *)qualloc(strlen(newString)+1);
    } else {
        free(label);
        label = (char *)qualloc(sizeof(char) * (strlen(newString)+1));
    }
    Init_String(label, newString, 0);
}
bool Selector::SetTrigger(short trigval) {
    trig = trigval;
}
bool Selector::SetFunction(void (*funct)(void)) {
    function = funct;
    callfunct = true;
}
bool Selector::Enable(void) {
    return disabled = false;
}
bool Selector::Disable(void) {
    return disabled = true;
}
bool Selector::Hide(void) {
    return visible = false;
}
bool Selector::Show(void) {
    return visible = true;
}
bool Selector::NoSelect(void) {
    selectable = false;
    return selectable;
}
bool Selector::Select(void) {
    selectable = true;
    return selectable;
}
bool Selector::Check(short xLocation, short yLocation) {
    if(visible) {
        if(!disabled) {
            if(selectable) {
                if(mouse_inarea(xPos + xLocation, yPos + yLocation, width, height)) {
                    if(mouse_b & 1) {
                        if(ref != NULL) {
                            *ref = trig;
                        }
                        if(callfunct) {
                            function();
                        }
                    }
                }
            }
        }
    }
    return false;
}
void Selector::Draw(BITMAP *output, short xLocation, short yLocation) {
    if(visible) {
        if(image == NULL) {
            if(label != NULL)
                selector(output, xPos + xLocation, yPos + yLocation, width, height, NULL, label);
        } else {
            selector(output, xPos + xLocation, yPos + yLocation, width, height, image, NULL);
        }
        if(*ref == trig) {
            set_trans_blender(0, 0, 0, 128);
            draw_trans_sprite(output, highlight, xPos + xLocation, yPos + yLocation);
        }
        if(disabled) {
            set_trans_blender(0, 0, 0, 160);
            draw_trans_sprite(output, layer, xPos + xLocation, yPos + yLocation);
        }
    }
}
